<?php
require 'header.php';
require 'db.php';
$q = $_GET['q'] ?? '';
$rows = [];
if ($q) {
  $stmt = $conn->prepare("SELECT id, invoice_no, customer_name, date, total_amount FROM invoices WHERE invoice_no LIKE ? OR customer_name LIKE ? ORDER BY id DESC");
  $like = "%$q%";
  $stmt->bind_param("ss", $like, $like);
  $stmt->execute();
  $res = $stmt->get_result();
  while ($r = $res->fetch_assoc()) $rows[] = $r;
}
?>
<style>
body{font-family:'Inter','SolaimanLipi';background:#f9fafb;padding:20px;}
.container{max-width:980px;margin:auto;background:#fff;padding:20px;border-radius:10px;box-shadow:0 6px 20px rgba(2,6,23,0.04);}
h2{margin:0 0 12px 0}
.form-row{display:flex;gap:8px;align-items:center}
.input-search{padding:8px;width:70%;border:1px solid #e5e7eb;border-radius:6px}
.btn-search{padding:8px 12px;border:none;background:#2563eb;color:#fff;border-radius:6px;cursor:pointer}
table{width:100%;border-collapse:collapse;margin-top:14px;font-size:14px}
th,td{border:1px solid #e5e7eb;padding:10px;text-align:left;vertical-align:middle}
th{background:#fbfdff;font-weight:800}

/* ===== Buttons in one line ===== */
.action-links{
  display:inline-flex;
  align-items:center;
  justify-content:flex-start;
  gap:6px;               /* small gap between buttons */
}
.action-links a{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  gap:6px;
  padding:8px 12px;
  border-radius:8px;
  text-decoration:none;
  color:#fff;
  font-weight:700;
  font-size:13px;
  transition:0.2s ease;
  white-space:nowrap;
}
.action-links a:hover{opacity:0.9;transform:translateY(-1px);}
.view-btn{background:linear-gradient(180deg,#10b981,#059669);}
.edit-btn{background:linear-gradient(180deg,#f59e0b,#d97706);}
.delete-btn{background:linear-gradient(180deg,#ef4444,#b91c1c);}
.no-results{padding:12px;margin-top:12px;background:#fffbeb;border:1px solid #fef3c7;border-radius:6px;color:#92400e}
</style>

<div class="container">
  <h2>Search Invoice</h2>
  <form>
    <div class="form-row">
      <input name="q" value="<?php echo htmlspecialchars($q); ?>" placeholder="Invoice no or customer name" class="input-search">
      <button type="submit" class="btn-search">Search</button>
      <a href="invoice.php" style="margin-left:auto;text-decoration:none;padding:8px 12px;background:#0f172a;color:#fff;border-radius:6px;font-weight:700">Create Invoice</a>
    </div>
  </form>

  <?php if($q): ?>
    <?php if(count($rows)===0): ?>
      <div class="no-results">কোনো রেকর্ড পাওয়া যায়নি। অনুগ্রহ করে অন্য কীওয়ার্ড দিয়ে চেষ্টা করুন।</div>
    <?php else: ?>
    <table>
      <thead>
        <tr>
          <th style="width:12%">Invoice</th>
          <th style="width:36%">Customer</th>
          <th style="width:16%">Date</th>
          <th style="width:16%">Total</th>
          <th style="width:20%">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
        <tr>
          <td><?php echo htmlspecialchars($r['invoice_no']); ?></td>
          <td><?php echo htmlspecialchars($r['customer_name']); ?></td>
          <td><?php echo htmlspecialchars($r['date']); ?></td>
          <td><?php echo htmlspecialchars(number_format($r['total_amount'],2)); ?></td>
          <td>
            <div class="action-links">
              <a class="view-btn" href="print_invoice.php?invoice_no=<?php echo urlencode($r['invoice_no']); ?>" target="_blank">
                <i class="bi bi-eye"></i> View
              </a>
              <a class="edit-btn" href="edit_invoice.php?invoice_no=<?php echo urlencode($r['invoice_no']); ?>">
                <i class="bi bi-pencil-square"></i> Edit
              </a>
              <a class="delete-btn" href="delete_invoice.php?invoice_no=<?php echo urlencode($r['invoice_no']); ?>" onclick="return confirm('Are you sure to delete this invoice?')">
                <i class="bi bi-trash"></i> Delete
              </a>
            </div>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <?php endif; ?>
  <?php endif; ?>
</div>

<?php require 'footer.php'; ?>
