<?php
session_start();
require 'db.php';
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    $stmt = $conn->prepare('SELECT id, username, password FROM users WHERE username = ? LIMIT 1');
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($row = $res->fetch_assoc()) {
        // NOTE: current demo checks plaintext. If you store hashed passwords, replace the next line with password_verify().
        if ($password === $row['password']) {
            $_SESSION['user'] = $row['username'];
            header('Location: dashboard.php');
            exit;
        } else {
            $msg = 'Invalid credentials';
        }
    } else {
        $msg = 'Invalid credentials';
    }
}
?>
<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login - Smart Jewelry</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(180deg,#eef6f1,#f6fbff);
      font-family: Inter, Arial, Helvetica, sans-serif;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 24px;
      color: #0f172a;
    }

    .login-card {
      width: 100%;
      max-width: 420px;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 10px 30px rgba(16,24,40,0.08);
      overflow: hidden;
      border: 1px solid #e6f0ea;
    }

    .login-head {
      background: linear-gradient(90deg,#0f9d58,#16a34a);
      color: #fff;
      padding: 22px 20px;
      display: flex;
      align-items: center;
      gap: 14px;
    }
    .login-head h2 { margin:0; font-size:20px; }
    .login-body { padding: 22px; }

    .form-control:focus {
      box-shadow: 0 0 0 0.18rem rgba(16,185,129,0.15);
      border-color: #10b981;
    }

    .btn-primary {
      background: linear-gradient(90deg,#06b56a,#0f9d58);
      border: none;
      box-shadow: 0 6px 18px rgba(16,24,40,0.06);
    }

    .muted { color: #6b7280; font-size:14px; }

    .footer-note {
      text-align:center;
      padding:14px 18px;
      background:#fbfff9;
      border-top:1px solid #eef6ea;
      font-size:13px;
      color:#374151;
    }

    .show-pass {
      cursor:pointer;
      user-select:none;
    }

    @media (max-width:420px){
      .login-card { margin: 0 8px; }
    }
  </style>
</head>
<body>

  <div class="login-card">
    <div class="login-head">
      <svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
        <path d="M12 2L15.5 8l6 1.2-4.5 4 1.1 6L12 17.5 4.9 19.2 6 13.2 1.5 9.2 7.5 8 12 2z" fill="white"/>
      </svg>
      <div>
        <h2>Smart Jewelry</h2>
        <div style="font-size:13px;opacity:0.95">অ্যাডমিন লগইন</div>
      </div>
    </div>

    <div class="login-body">
      <?php if($msg): ?>
        <div class="alert alert-danger py-2" role="alert">
          <?php echo htmlspecialchars($msg) ?>
        </div>
      <?php endif; ?>

      <form method="post" novalidate>
        <div class="mb-3">
          <label class="form-label">ইউজারনেম</label>
          <input name="username" class="form-control" required autofocus placeholder="আপনার ইউজারনেম লিখুন" />
        </div>

        <div class="mb-3">
          <label class="form-label">পাসওয়ার্ড</label>
          <div class="input-group">
            <input name="password" id="passwordField" type="password" class="form-control" required placeholder="পাসওয়ার্ড">
            <span class="input-group-text show-pass" id="togglePass" title="Show / Hide">প্রদর্শন</span>
          </div>
        </div>

        <div class="d-flex justify-content-between align-items-center mb-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="" id="rememberMe">
            <label class="form-check-label muted" for="rememberMe">মনে রাখো</label>
          </div>
          <a href="#" class="muted" style="text-decoration:none">পাসওয়ার্ড ভুলে গেছেন?</a>
        </div>

        <div class="d-grid">
          <button type="submit" class="btn btn-primary btn-lg">লগইন</button>
        </div>
      </form>

      <hr style="margin:18px 0">

     

    <div class="footer-note">
      © <?php echo date('Y'); ?> Smart Jewelry — কারিগরি সহায়তায় Software Lab BD
    </div>
  </div>

<script>
  // toggle show/hide password
  document.getElementById('togglePass').addEventListener('click', function(){
    const f = document.getElementById('passwordField');
    if(f.type === 'password'){ f.type = 'text'; this.textContent = 'গোপন'; }
    else { f.type = 'password'; this.textContent = 'প্রদর্শন'; }
  });
</script>

</body>
</html>
