<?php
// stock_list.php
require 'header.php';
require 'db.php';
require 'unit_converters.php';

// Fetch items
$res = $conn->query("SELECT * FROM stock ORDER BY id DESC");
if ($res === false) {
    error_log("Query failed: " . $conn->error);
    $items = [];
} else {
    $items = $res->fetch_all(MYSQLI_ASSOC);
}

// Flash message
$flash = '';
if (isset($_GET['deleted']) && $_GET['deleted'] == '1') {
    $flash = '<div style="padding:10px;background:#ecfdf5;color:#065f46;border-radius:8px;margin-bottom:12px;">✅ Item deleted successfully.</div>';
} elseif (isset($_GET['error'])) {
    $err = htmlspecialchars($_GET['error']);
    $flash = '<div style="padding:10px;background:#fff1f2;color:#991b1b;border-radius:8px;margin-bottom:12px;">⚠️ Error: ' . $err . '</div>';
}
?>

<div class="card" style="padding:20px; background:#ffffff; border-radius:12px; box-shadow:0 1px 4px rgba(0,0,0,0.08);">
  <h2 style="font-size:22px; margin-bottom:6px;">📦 Items (Stock)</h2>
  <p style="color:#6b7280; font-size:14px; margin-bottom:12px;">
    All stock items — with full weight breakdown (ভরি / আনা / রটি / পয়েন্ট / গ্রাম).
  </p>

  <?php echo $flash; ?>

  <div style="overflow:auto;">
    <table style="width:100%; border-collapse:collapse; min-width:950px; font-size:15px;">
      <thead>
        <tr style="background:#f1f5f9; color:#111827; text-align:left;">
          <th style="padding:10px;">ID</th>
          <th style="padding:10px;">SKU</th>
          <th style="padding:10px;">Name</th>
          <th style="padding:10px;">Category</th>
          <th style="padding:10px; text-align:center;">Qty</th>
          <th style="padding:10px; text-align:center;">Weight Breakdown</th>
          <th style="padding:10px;">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $r): 
          $u = gramsToUnits(floatval($r['weight_g'] ?? 0)); ?>
        <tr style="border-bottom:1px solid #f3f4f6; transition:background 0.2s;" 
            onmouseover="this.style.background='#f9fafb'" 
            onmouseout="this.style.background='transparent'">

          <td style="padding:10px;"><?php echo (int)$r['id']; ?></td>
          <td style="padding:10px;"><?php echo htmlspecialchars($r['sku']); ?></td>
          <td style="padding:10px;"><?php echo htmlspecialchars($r['name']); ?></td>
          <td style="padding:10px;"><?php echo htmlspecialchars(ucfirst($r['category'])); ?></td>
          <td style="padding:10px; text-align:center;"><?php echo (int)$r['quantity']; ?></td>

          <td style="padding:10px; text-align:center;">
            <div style="display:inline-block; text-align:left; background:#f9fafb; padding:8px 12px; border-radius:8px; line-height:1.5;">
              <strong><?php echo $u['vori']; ?></strong> ভরি <br>
              <strong><?php echo $u['ana']; ?></strong> আনা <br>
              <strong><?php echo $u['roti']; ?></strong> রটি <br>
              <strong><?php echo $u['point']; ?></strong> পয়েন্ট <br>
              <small style="color:#6b7280;"><?php echo number_format($u['grams'],4); ?> g</small>
            </div>
          </td>

          <td style="padding:10px;">
            <a href="stock_in.php?id=<?php echo $r['id']; ?>" 
               style="color:#2563eb; text-decoration:none; margin-right:8px;">➕ In</a>

            <a href="stock_out.php?id=<?php echo $r['id']; ?>" 
               style="color:#d97706; text-decoration:none; margin-right:8px;">📦 Out</a>

            <a href="sell.php?id=<?php echo $r['id']; ?>" 
               style="color:#16a34a; text-decoration:none; margin-right:8px;">💰 Sell</a>

            <!-- Important: return param points to the exact path you want to come back to -->
            <a href="delete_item.php?id=<?php echo $r['id']; ?>&return=/stock_list.php" 
               onclick="return confirm('Are you sure you want to delete this item?');" 
               style="color:#dc2626; text-decoration:none;">🗑️ Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require 'footer.php'; ?>
