<?php
require 'header.php';
require 'db.php';

$msg = '';
$id = intval($_GET['id'] ?? 0);

$name = '';
$phone = '';
$address = '';
$note = '';
$balance = '0.00';

if ($id > 0) {
    $stmt = $conn->prepare('SELECT id, name, phone, address, note, balance FROM customers WHERE id = ? LIMIT 1');
    if ($stmt) {
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($row = $res->fetch_assoc()) {
            $name = $row['name'];
            $phone = $row['phone'];
            $address = $row['address'];
            $note = $row['note'];
            $balance = number_format($row['balance'], 2, '.', '');
        } else {
            $msg = 'কাস্টমার খুঁজে পাওয়া যায়নি।';
            $id = 0;
        }
        $stmt->close();
    } else {
        $msg = 'ডাটাবেইস ত্রুটি: ' . $conn->error;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $post_id = intval($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $note = trim($_POST['note'] ?? '');
    $balance_input = str_replace(',', '', trim($_POST['balance'] ?? '0'));
    $balance = is_numeric($balance_input) ? floatval($balance_input) : 0.0;

    if ($name === '') {
        $msg = 'কাস্টমারের নাম দিন।';
    } else {
        if ($post_id > 0) {
            $stmt = $conn->prepare('UPDATE customers SET name = ?, phone = ?, address = ?, note = ?, balance = ? WHERE id = ?');
            if ($stmt === false) {
                $msg = 'আপডেট প্রস্তুত হয়নি: ' . $conn->error;
            } else {
                $stmt->bind_param('sssddi', $name, $phone, $address, $note, $balance, $post_id);
                if ($stmt->execute()) {
                    header('Location: my-customer.php?updated=1');
                    exit;
                } else {
                    $msg = 'আপডেট ব্যর্থ হয়েছে: ' . $stmt->error;
                }
                $stmt->close();
            }
        } else {
            $stmt = $conn->prepare('INSERT INTO customers (name, phone, address, note, balance) VALUES (?,?,?,?,?)');
            if ($stmt === false) {
                $msg = 'ইনসার্ট প্রস্তুত হয়নি: ' . $conn->error;
            } else {
                $stmt->bind_param('ssssd', $name, $phone, $address, $note, $balance);
                if ($stmt->execute()) {
                    header('Location: my-customer.php?created=1');
                    exit;
                } else {
                    $msg = 'সংরক্ষণ ব্যর্থ হয়েছে: ' . $stmt->error;
                }
                $stmt->close();
            }
        }
    }
}
?>

<link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;600;700&display=swap" rel="stylesheet">

<style>
  :root {
    --primary: #4f46e5;
    --muted: #6b7280;
    --bg:#f7f9fc;
    --card:#ffffff;
    --shadow: 0 8px 25px rgba(0,0,0,0.06);
    font-family: 'Hind Siliguri', sans-serif;
  }

  .container{max-width:820px;margin:32px auto;padding:20px;}
  .card{background:var(--card);padding:26px;border-radius:14px;box-shadow:var(--shadow);}
  .title{font-size:22px;font-weight:700;margin-bottom:6px}
  .subtitle{color:var(--muted);margin-bottom:16px;font-size:14px}

  .msg{padding:10px 14px;border-radius:10px;margin-bottom:14px;font-size:14px;}
  .msg.error{background:#fff1f2;color:#dc2626;border:1px solid #fecaca}
  .msg.success{background:#ecfdf5;color:#16a34a;border:1px solid #bbf7d0}

  label{display:flex;flex-direction:column;font-size:15px;margin-bottom:12px}
  .input,textarea{
    padding:12px;border-radius:10px;
    border:1px solid #e5e7eb;font-size:15px;transition:.2s;
  }
  .input:focus,textarea:focus{border-color:var(--primary);box-shadow:0 0 0 3px rgba(79,70,229,0.15)}

  textarea{min-height:90px;resize:vertical;}

  .btn{
    padding:10px 16px;border-radius:10px;text-decoration:none;
    font-weight:700;cursor:pointer;transition:.2s;font-size:15px;
  }
  .btn-primary{background:var(--primary);color:#fff;border:none;}
  .btn-primary:hover{opacity:.9}
  .btn-light{background:#f3f4f6;color:#111;}
</style>

<div class="container">
  <div class="card">

    <div class="title"><?php echo $id ? 'কাস্টমার সম্পাদনা' : 'নতুন কাস্টমার যোগ করুন'; ?></div>
    <div class="subtitle">আপনার কাস্টমারের তথ্য সংরক্ষণ করুন এবং প্রয়োজন অনুযায়ী আপডেট করুন।</div>

    <?php if ($msg): ?>
      <div class="msg <?php echo (stripos($msg,'ব্যর্থ')!==false||stripos($msg,'ত্রুটি')!==false) ? 'error':'success'; ?>">
        <?= htmlspecialchars($msg); ?>
      </div>
    <?php endif; ?>

    <form method="post">
      <input type="hidden" name="id" value="<?= $id ?>">

      <label>
        কাস্টমারের নাম <span style="color:red">*</span>
        <input class="input" type="text" name="name" value="<?= htmlspecialchars($name); ?>" required>
      </label>

      <label>
        মোবাইল নম্বর
        <input class="input" type="text" name="phone" placeholder="০১XXXXXXXXX" value="<?= htmlspecialchars($phone); ?>">
      </label>

      <label>
        ঠিকানা
        <textarea name="address" class="input"><?= htmlspecialchars($address); ?></textarea>
      </label>

      <label>
        নোট (ঐচ্ছিক)
        <input class="input" type="text" name="note" value="<?= htmlspecialchars($note); ?>">
      </label>

      <label>
        শুরুর বকেয়া (৳)
        <input class="input" type="number" step="0.01" name="balance" value="<?= htmlspecialchars($balance); ?>">
      </label>

      <div style="margin-top:15px;display:flex;gap:10px">
        <button type="submit" class="btn btn-primary"><?= $id ? 'আপডেট করুন' : 'সংরক্ষণ করুন' ?></button>
        <a href="my-customer.php" class="btn btn-light">ফিরে যান</a>
      </div>

    </form>
  </div>
</div>

<?php require 'footer.php'; ?>
