<?php
require 'header.php';
require 'db.php'; // provides $conn (mysqli)
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
.container{max-width:880px;margin:20px auto}
.card{background:#fff;border-radius:10px;padding:18px;box-shadow:0 6px 18px rgba(0,0,0,0.06)}
.form-row{display:flex;gap:10px;flex-wrap:wrap}
.form-row .col{flex:1;min-width:180px}
label{display:block;margin-bottom:6px;font-weight:600}
input,select{width:100%;padding:8px;border:1px solid #ddd;border-radius:6px}
.btn{padding:10px 14px;border-radius:8px;background:#0ea5a4;color:#fff;border:none;cursor:pointer}
.preview {max-height:90px; margin-top:8px;}
.note{color:#6b7280;font-size:13px}
</style>

<div class="container">
  <div class="card">
    <h3><i class="bi bi-person-plus"></i> Add Bondhoki (Add Customer)</h3>
    <p class="note">পছন্দমতো ছবি আপলোড করো, মাস, আদি টাকার পরিমাণ ও বার্ষিক (%) সুদ সেট করো।</p>

    <form action="save_bondhoki.php" method="post" enctype="multipart/form-data">
      <div class="form-row">
        <div class="col">
          <label for="name">Customer Name</label>
          <input type="text" id="name" name="name" required>
        </div>
        <div class="col">
          <label for="phone">Phone</label>
          <input type="text" id="phone" name="phone">
        </div>
      </div>

      <div class="form-row" style="margin-top:10px">
        <div class="col">
          <label for="item_name">Item Name (পণ্যের নাম)</label>
          <input type="text" id="item_name" name="item_name" required>
        </div>
        <div class="col">
          <label for="image">Item Image (optional)</label>
          <input type="file" id="image" name="image" accept="image/*">
          <img id="imgPreview" class="preview" src="" alt="" style="display:none">
        </div>
      </div>

      <div class="form-row" style="margin-top:10px">
        <div class="col">
          <label for="amount">Bondhoki Amount (টাকা)</label>
          <input type="number" step="0.01" id="amount" name="amount" required>
        </div>
        <div class="col">
          <label for="percent">Annual Profit % (বার্ষিক সুদ %)</label>
          <input type="number" step="0.01" id="percent" name="percent" value="12" required>
        </div>
        <div class="col">
          <label for="months">Months (মাস)</label>
          <input type="number" id="months" name="months" value="12" min="1" required>
        </div>
      </div>

      <div style="margin-top:12px">
        <label for="start_date">Start Date</label>
        <input type="date" id="start_date" name="start_date" value="<?php echo date('Y-m-d'); ?>" required>
      </div>

      <div style="margin-top:14px">
        <button class="btn" type="submit">Save Bondhoki</button>
        <a href="bondhoki_list.php" style="margin-left:10px;">View Bondhoki List</a>
      </div>
    </form>
  </div>
</div>

<script>
// image preview
document.getElementById('image').addEventListener('change', function(e){
  const file = this.files[0];
  if(!file) return;
  const url = URL.createObjectURL(file);
  const img = document.getElementById('imgPreview');
  img.src = url; img.style.display = 'block';
});
</script>

<?php require 'footer.php'; ?>
