<?php
require 'header.php';
require 'db.php';
require 'unit_converters.php';

// --- totals by category
$cats = ['gold'=>'Gold','silver'=>'Rupa','diamond'=>'Hira'];
$categoryTotals = [];
foreach($cats as $key => $label) {
    $res = $conn->query("SELECT SUM(weight_g) as total_g, SUM(quantity) as total_qty FROM stock WHERE category='{$key}'");
    $row = $res->fetch_assoc();
    $total_g = floatval($row['total_g'] ?? 0);
    $total_qty = intval($row['total_qty'] ?? 0);
    $units = gramsToUnits($total_g); // expect keys: vori, ana, roti, point, grams
    $categoryTotals[$key] = ['label'=>$label,'grams'=>$total_g,'qty'=>$total_qty, 'units'=>$units];
}

// --- overall stock totals
$overallStockRes = $conn->query("SELECT COALESCE(SUM(weight_g),0) as total_stock_g, COALESCE(SUM(quantity),0) as total_stock_qty FROM stock");
$overallRow = $overallStockRes->fetch_assoc();
$overall_stock_g = floatval($overallRow['total_stock_g'] ?? 0);
$overall_stock_qty = intval($overallRow['total_stock_qty'] ?? 0);
$overall_stock_units = gramsToUnits($overall_stock_g);

// --- total sales summary (no monetary totals)
$totalSalesRes = $conn->query("SELECT COALESCE(SUM(qty),0) AS total_sales_qty, COALESCE(SUM(sold_weight_g),0) AS total_sold_weight_g FROM sales");
$totalSalesRow = $totalSalesRes->fetch_assoc();
$total_sales_qty = intval($totalSalesRow['total_sales_qty'] ?? 0);
$total_sold_weight_g = floatval($totalSalesRow['total_sold_weight_g'] ?? 0);
$total_sold_units = gramsToUnits($total_sold_weight_g);

// --- total stock out summary
$stockOutRes = $conn->query("SELECT COALESCE(SUM(out_weight_g),0) AS total_out_g, COALESCE(COUNT(id),0) AS total_out_count FROM stock_out_records");
$stockOutRow = $stockOutRes->fetch_assoc();
$total_out_g = floatval($stockOutRow['total_out_g'] ?? 0);
$total_out_count = intval($stockOutRow['total_out_count'] ?? 0);
$total_out_units = gramsToUnits($total_out_g);
?>

<!-- Fonts & Icons -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
:root{
  --bg: linear-gradient(180deg,#f6f8fb,#eef6ff);
  --muted:#6b7280;
  --card-shadow: 0 10px 30px rgba(16,24,40,0.08);
  --glass: rgba(255,255,255,0.65);
  --glass-2: rgba(255,255,255,0.9);
  --radius: 14px;
  --accent: #0ea5a4;
}

/* Base */
*{box-sizing:border-box;font-family:Inter, system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial}
body{background:var(--bg);padding:28px;color:#0f172a;margin:0}
.container{max-width:1200px;margin:0 auto}

/* Header */
.header-row{display:flex;align-items:center;justify-content:space-between;gap:12px;margin-bottom:18px}
.title{font-size:24px;font-weight:800;color:#063c3a}
.subtitle{color:var(--muted);font-size:13px;margin-top:4px}

/* Controls */
.controls{display:flex;gap:10px;align-items:center}
.btn{background:transparent;border:1px solid rgba(15,23,42,0.06);padding:8px 12px;border-radius:10px;cursor:pointer;color:#0f172a;text-decoration:none;display:inline-flex;align-items:center;gap:8px;font-weight:600;box-shadow:0 2px 6px rgba(2,6,23,0.03)}
.btn.primary{background:linear-gradient(90deg,#06b6d4,#0ea5a4);color:#fff;border:none;box-shadow:0 8px 20px rgba(14,165,164,0.18)}
.btn.ghost{background:transparent;border:1px dashed rgba(15,23,42,0.06)}

/* Grid */
.grid{display:grid;grid-template-columns:repeat(12,1fr);gap:18px;align-items:stretch}

/* Category cards */
.cat-card{grid-column:span 4;padding:18px;border-radius:var(--radius);color:#08203a;display:flex;flex-direction:column;gap:12px;box-shadow:var(--card-shadow);position:relative;overflow:hidden;min-height:120px;transition:transform .18s ease, box-shadow .18s ease}
.cat-card:hover{transform:translateY(-6px);box-shadow:0 18px 40px rgba(16,24,40,0.12)}
.cat-top{display:flex;justify-content:space-between;align-items:flex-start}
.cat-label{font-weight:700;font-size:16px}
.cat-qty{font-weight:800;font-size:18px}
.cat-sub{color:var(--muted);font-size:13px}

/* specific color themes */
.cat-gold{background:linear-gradient(135deg,#fffaf3 0%,#fff6e6 40%,#fff0d6 100%);border:1px solid rgba(255,183,77,0.12)}
.cat-silver{background:linear-gradient(135deg,#f8fbff 0%,#f2f6fb 40%,#e9eef6 100%);border:1px solid rgba(160,172,184,0.10)}
.cat-diamond{background:linear-gradient(135deg,#f3fbff 0%,#eaf7ff 40%,#dff1ff 100%);border:1px solid rgba(109,173,255,0.12)}

/* breakdown list */
.breakdown{display:flex;gap:10px;flex-wrap:wrap;margin-top:6px}
.break-item{background:var(--glass-2);border-radius:10px;padding:8px 10px;font-size:13px;min-width:90px;text-align:center;box-shadow:0 6px 16px rgba(2,6,23,0.03)}
.break-item .num{font-weight:800;font-size:16px}
.break-item .lbl{color:var(--muted);font-size:12px;margin-top:4px}

/* Main summary band */
.main-summary { grid-column:span 12; display:flex; gap:14px; margin-top:4px; }
.summary-card { flex:1; background: linear-gradient(180deg,#ffffff,#fbfeff); border-radius:12px; padding:16px; box-shadow:var(--card-shadow); display:flex; flex-direction:column; justify-content:space-between; min-height:90px; transition:transform .15s ease}
.summary-card:hover{transform:translateY(-6px)}
.summary-card .label{color:var(--muted);font-size:13px}
.summary-card .value{font-size:20px;font-weight:800;margin-top:8px}
.summary-card .sub{color:var(--muted);font-size:13px;margin-top:8px}

/* small badges */
.badge{display:inline-block;padding:6px 8px;border-radius:999px;font-weight:700;font-size:12px;color:#fff}
.badge.green{background:linear-gradient(90deg,#16a34a,#4ade80)}
.badge.blue{background:linear-gradient(90deg,#2563eb,#60a5fa)}
.badge.orange{background:linear-gradient(90deg,#f59e0b,#fb923c)}

/* footer / spacing */
.spacer{height:14px}

/* Responsive adjustments */
@media (max-width:1100px) {
  .cat-card{grid-column:span 6}
  .main-summary{flex-direction:column}
}
@media (max-width:640px) {
  .header-row{flex-direction:column;align-items:flex-start;gap:10px}
  .controls{width:100%;justify-content:space-between}
  .grid{gap:12px}
  .cat-card{grid-column:span 12}
  .break-item{min-width:72px;padding:6px 8px}
  .title{font-size:20px}
  .summary-card .value{font-size:18px}
}
</style>

<div class="container">
  <div class="header-row">
    <div>
      <div class="title">Dashboard</div>
      <div class="subtitle">সার্বিক স্টক ও বিক্রয়ের বিস্তারিত — ভরি/আনা/রটি/পয়েন্ট সহ</div>
    </div>

    <div class="controls" role="toolbar" aria-label="Dashboard actions">
      <a href="items.php" class="btn"><i class="bi bi-box-seam"></i> Items</a>
      <a href="recent_sales.php" class="btn"><i class="bi bi-clock-history"></i> Recent Sales</a>
      <a href="reports.php" class="btn primary"><i class="bi bi-bar-chart-fill"></i> Reports</a>
    </div>
  </div>

  <div class="grid">
    <!-- Gold card -->
    <div class="cat-card cat-gold" role="region" aria-labelledby="goldHeading">
      <div class="cat-top">
        <div>
          <div id="goldHeading" class="cat-label">Gold</div>
          <div class="cat-sub">Total pieces: <strong><?php echo $categoryTotals['gold']['qty'] ?></strong></div>
        </div>
        <div style="text-align:right">
          <div class="cat-qty"><?php echo $categoryTotals['gold']['units']['vori'] ?> ভরি <?php echo $categoryTotals['gold']['units']['ana'] ?> আনা</div>
          <div class="cat-sub"><?php echo number_format($categoryTotals['gold']['grams'],4) ?> g</div>
        </div>
      </div>

      <div class="breakdown" aria-hidden="false">
        <div class="break-item"><div class="num"><?php echo $categoryTotals['gold']['units']['vori'] ?></div><div class="lbl">ভরি</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['gold']['units']['ana'] ?></div><div class="lbl">আনা</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['gold']['units']['roti'] ?></div><div class="lbl">রটি</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['gold']['units']['point'] ?></div><div class="lbl">পয়েন্ট</div></div>
        <div class="break-item" style="min-width:120px"><div class="num"><?php echo number_format($categoryTotals['gold']['grams'],4) ?></div><div class="lbl">গ্রাম মোট</div></div>
      </div>
    </div>

    <!-- Silver card -->
    <div class="cat-card cat-silver" role="region" aria-labelledby="silverHeading">
      <div class="cat-top">
        <div>
          <div id="silverHeading" class="cat-label">silver</div>
          <div class="cat-sub">Total pieces: <strong><?php echo $categoryTotals['silver']['qty'] ?></strong></div>
        </div>
        <div style="text-align:right">
          <div class="cat-qty"><?php echo $categoryTotals['silver']['units']['vori'] ?> ভরি <?php echo $categoryTotals['silver']['units']['ana'] ?> আনা</div>
          <div class="cat-sub"><?php echo number_format($categoryTotals['silver']['grams'],4) ?> g</div>
        </div>
      </div>

      <div class="breakdown">
        <div class="break-item"><div class="num"><?php echo $categoryTotals['silver']['units']['vori'] ?></div><div class="lbl">ভরি</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['silver']['units']['ana'] ?></div><div class="lbl">আনা</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['silver']['units']['roti'] ?></div><div class="lbl">রটি</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['silver']['units']['point'] ?></div><div class="lbl">পয়েন্ট</div></div>
        <div class="break-item" style="min-width:120px"><div class="num"><?php echo number_format($categoryTotals['silver']['grams'],4) ?></div><div class="lbl">গ্রাম মোট</div></div>
      </div>
    </div>

    <!-- Diamond card -->
    <div class="cat-card cat-diamond" role="region" aria-labelledby="diamondHeading">
      <div class="cat-top">
        <div>
          <div id="diamondHeading" class="cat-label">diamond</div>
          <div class="cat-sub">Total pieces: <strong><?php echo $categoryTotals['diamond']['qty'] ?></strong></div>
        </div>
        <div style="text-align:right">
          <div class="cat-qty"><?php echo $categoryTotals['diamond']['units']['vori'] ?> ভরি <?php echo $categoryTotals['diamond']['units']['ana'] ?> আনা</div>
          <div class="cat-sub"><?php echo number_format($categoryTotals['diamond']['grams'],4) ?> g</div>
        </div>
      </div>

      <div class="breakdown">
        <div class="break-item"><div class="num"><?php echo $categoryTotals['diamond']['units']['vori'] ?></div><div class="lbl">ভরি</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['diamond']['units']['ana'] ?></div><div class="lbl">আনা</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['diamond']['units']['roti'] ?></div><div class="lbl">রটি</div></div>
        <div class="break-item"><div class="num"><?php echo $categoryTotals['diamond']['units']['point'] ?></div><div class="lbl">পয়েন্ট</div></div>
        <div class="break-item" style="min-width:120px"><div class="num"><?php echo number_format($categoryTotals['diamond']['grams'],4) ?></div><div class="lbl">গ্রাম মোট</div></div>
      </div>
    </div>

    <!-- Main summary (three cards) -->
    <div class="main-summary" style="grid-column:span 12;">
      <div class="summary-card" role="article" aria-label="Total pieces sold">
        <div>
          <div class="label">Total Pieces Sold</div>
          <div class="value"><?php echo $total_sales_qty ?> pieces</div>
        </div>
        <div class="sub">Weight sold: <strong><?php echo $total_sold_units['vori'].' ভরি '.$total_sold_units['ana'].' আনা' ?></strong> (<?php echo $total_sold_units['grams'] ?> g)</div>
      </div>

      <div class="summary-card" role="article" aria-label="Total Stock Out">
        <div>
          <div class="label">Total Stock Out (manual)</div>
          <div class="value"><?php echo $total_out_units['vori'].' ভরি '.$total_out_units['ana'].' আনা' ?></div>
        </div>
        <div class="sub"><?php echo $total_out_units['grams'] ?> g — <?php echo $total_out_count ?> records</div>
      </div>

      <div class="summary-card" role="article" aria-label="Total Stock">
        <div>
          <div class="label">Total Stock (all categories)</div>
          <div class="value"><?php echo $overall_stock_units['vori'].' ভরি '.$overall_stock_units['ana'].' আনা' ?></div>
        </div>
        <div class="sub"><?php echo $overall_stock_units['grams'] ?> g — <?php echo $overall_stock_qty ?> pieces</div>
      </div>
    </div>

  </div><!-- .grid -->

  <div class="spacer"></div>
</div><!-- .container -->

<?php require 'footer.php'; ?>
