<?php
// header.php
session_start();

// Redirect to login if not logged in
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

// Optional: if your session stores name as $_SESSION['user']['name']
$userName = '';
if (is_array($_SESSION['user']) && isset($_SESSION['user']['name'])) {
    $userName = htmlspecialchars($_SESSION['user']['name']);
} elseif (is_string($_SESSION['user'])) {
    // fallback if session stores username as string
    $userName = htmlspecialchars($_SESSION['user']);
}
?>
<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Smart Jewelry - Dashboard</title>

  <!-- Fonts & Icons -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
  /* Base layout */
  :root{
    --green-1: #16a34a;
    --green-2: #0f9d58;
    --header-height: 64px;
    --sidebar-width: 230px;
    --muted: #6b7280;
  }
  *{box-sizing:border-box;font-family:Inter, Arial, Helvetica, sans-serif}
  body {
    margin: 0;
    background: #f6f8fb;
    color: #111;
  }

  /* header */
  .site-header {
    height: var(--header-height);
    background: linear-gradient(90deg, var(--green-2), var(--green-1));
    color: #fff;
    padding: 10px 18px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    gap:12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    position:sticky;
    top:0;
    z-index:1000;
  }
  .brand { display:flex; align-items:center; gap:12px; }
  .brand .logo {
    width:40px;height:40px;border-radius:8px;background:rgba(255,255,255,0.12);display:flex;align-items:center;justify-content:center;font-size:20px;font-weight:700;
  }
  .brand h1 { margin:0;font-size:18px; font-weight:700; letter-spacing:0.4px; color:#fff; }
  .brand small { display:block;font-size:12px;opacity:0.95;color:rgba(255,255,255,0.9);margin-top:2px; }

  /* header actions */
  .header-actions { display:flex; align-items:center; gap:10px; }
  .user-pill { background: rgba(255,255,255,0.12); padding:6px 10px; border-radius:999px; color:#fff; display:flex;align-items:center; gap:8px; font-weight:600; font-size:14px; }
  .menu-toggle { display:none; background:transparent; border:0; color:#fff; font-size:20px; padding:8px; cursor:pointer; }

  /* layout wrap */
  .wrap { display:flex; min-height: calc(100vh - var(--header-height)); }

  /* sidebar */
  .sidebar {
    width: var(--sidebar-width);
    background: linear-gradient(180deg, var(--green-1), var(--green-2));
    padding:18px 12px;
    color:#fff;
    border-right: 3px solid rgba(0,0,0,0.06);
    box-shadow: 2px 0 10px rgba(0,0,0,0.06);
    transition: transform .22s ease;
  }
  .sidebar strong { display:block; font-size:15px; margin-bottom:10px; letter-spacing:0.4px; }
  .nav-link {
    display:block;
    padding:10px 12px;
    margin-bottom:8px;
    color:#fff;
    background: rgba(255,255,255,0.06);
    border-radius:8px;
    text-decoration:none;
    font-weight:600;
    transition: all .18s ease;
  }
  .nav-link i { margin-right:8px; font-size:16px; vertical-align:middle; }
  .nav-link:hover { background:#fff; color:var(--green-2); transform:translateX(6px); }

  .sidebar .section-title { margin-top:12px; display:block; font-size:13px; opacity:0.95; margin-bottom:6px; }

  /* main content */
  .main { flex:1; padding:20px; }

  /* small screens: hide sidebar by default, show toggle */
  @media (max-width: 900px) {
    .menu-toggle { display:inline-flex; }
    .sidebar { position:fixed; left:0; top:var(--header-height); height:calc(100vh - var(--header-height)); transform: translateX(-120%); z-index:1200; width:260px; overflow:auto; }
    .sidebar.open { transform: translateX(0); box-shadow: 8px 0 24px rgba(2,6,23,0.12); }
    .wrap { flex-direction:column; }
    .main { padding:16px; margin-top:0; }
  }

  /* responsive link layout when sidebar becomes full width */
  @media (max-width:480px) {
    .nav-link { font-size:14px; padding:10px; }
    .brand h1 { font-size:16px; }
  }

  /* accessibility focus */
  .nav-link:focus { outline: 3px solid rgba(255,255,255,0.18); outline-offset:2px; }
  </style>

</head>
<body>
  <header class="site-header" role="banner">
    <div class="brand" aria-label="Smart Jewelry brand">
      <div class="logo" aria-hidden="true">SJ</div>
      <div>
        <h1>Smart Jewelry</h1>
        <small>Modern Dashboard</small>
      </div>
    </div>

    <div class="header-actions">
      <button class="menu-toggle" id="menuToggle" aria-label="Toggle menu" title="Toggle menu"><i class="bi bi-list"></i></button>

      <?php if ($userName): ?>
        <div class="user-pill" aria-hidden="false">
          <i class="bi bi-person-circle" style="font-size:18px"></i>
          <span><?php echo $userName; ?></span>
        </div>
      <?php else: ?>
        <a href="profile.php" class="user-pill"><i class="bi bi-person-circle"></i> Profile</a>
      <?php endif; ?>
    </div>
  </header>

  <div class="wrap">
    <nav class="sidebar" id="mainSidebar" aria-label="Main navigation">
      <strong>Menu</strong>

      <a class="nav-link" href="dashboard.php"><i class="bi bi-house-door"></i> Home</a>
<a class="nav-link" href="stock_in.php"><i class="bi bi-box-arrow-in-down"></i> Stock In</a>
<a class="nav-link" href="stock_out.php"><i class="bi bi-box-arrow-up"></i> Stock Out (Manual)</a>
<a class="nav-link" href="sell.php"><i class="bi bi-cash-stack"></i> Sell</a>
<a class="nav-link" href="items.php"><i class="bi bi-card-checklist"></i> Items</a>
<a class="nav-link" href="recent_sales.php"><i class="bi bi-receipt"></i> Recent Sales</a>
<a class="nav-link" href="reports.php"><i class="bi bi-bar-chart-line"></i> Reports</a>
<a class="nav-link" href="my-customer.php"><i class="bi bi-people"></i> My Customers</a>
<a class="nav-link" href="add-customer.php"><i class="bi bi-person-plus"></i> Add Customer</a>
<a class="nav-link" href="bakikhata.php"><i class="bi bi-journal-bookmark"></i> Baki Khata</a>

<!-- 🧾 Invoice Section -->
<span class="section-title">Invoice</span>
<a class="nav-link" href="invoice.php"><i class="bi bi-file-earmark-plus"></i> Create Invoice</a>
<a class="nav-link" href="invoice_search.php"><i class="bi bi-search"></i> Search Invoice</a>

<span class="section-title">Bondhoki</span>
<a class="nav-link" href="bondhoki.php"><i class="bi bi-person-badge"></i> Add Bondhoki Customer</a>
<a class="nav-link" href="bondhoki_list.php"><i class="bi bi-card-list"></i> Bondhoki List</a>

<div style="margin-top:12px">
  <a class="nav-link" href="logout.php" style="background:rgba(255,255,255,0.06)">
    <i class="bi bi-box-arrow-right"></i> Logout
  </a>
</div>

    </nav>

    <main class="main" id="mainContent" role="main">
    <!-- main content starts here -->
