<?php
// unit_converters.php
// Conversion constants and helper functions for vori / ana / roti / point ↔ grams

// ১ ভরি = ১১.৬৬৪ গ্রাম
define('GRAM_PER_VORI', 11.664);

/**
 * Converts ভরি / আনা / রটি / পয়েন্ট → গ্রাম
 */
function unitsToGrams($vori = 0, $ana = 0, $roti = 0, $point = 0) {
    $vori  = floatval($vori);
    $ana   = floatval($ana);
    $roti  = floatval($roti);
    $point = floatval($point);

    // ১ ভরি = ১৬ আনা, ১ আনা = ৬ রটি, ১ রটি = ১০ পয়েন্ট
    $total_vori = $vori 
                + ($ana / 16.0)
                + ($roti / (16.0 * 6.0))
                + ($point / (16.0 * 6.0 * 10.0));

    return round($total_vori * GRAM_PER_VORI, 4);
}

/**
 * Converts গ্রাম → ভরি / আনা / রটি / পয়েন্ট
 */
function gramsToUnits($grams) {
    $grams = floatval($grams);
    if ($grams <= 0) {
        return ['vori' => 0, 'ana' => 0, 'roti' => 0, 'point' => 0, 'grams' => 0.0000];
    }

    // ১ ভরি = ১১.৬৬৪ গ্রাম
    $total_vori = $grams / GRAM_PER_VORI;

    $vori = floor($total_vori);
    $rem_vori = $total_vori - $vori;

    $total_ana = $rem_vori * 16.0;
    $ana = floor($total_ana);
    $rem_ana = $total_ana - $ana;

    $total_roti = $rem_ana * 6.0;
    $roti = floor($total_roti);
    $rem_roti = $total_roti - $roti;

    // পয়েন্ট পর্যন্ত হিসাব
    $point = round($rem_roti * 10.0, 2);

    return [
        'vori'  => (int)$vori,
        'ana'   => (int)$ana,
        'roti'  => (int)$roti,
        'point' => $point,
        'grams' => round($grams, 4)
    ];
}
?>
